<?php $__env->startSection('content'); ?>
<section>
	<div class="card elevation-0 mb-0 container-fluid ">
		<div class="card-body p-0">
			<div class="row">
				<div class="col-12 d-flex justify-content-between">
					<div class="gym-details d-flex">
						<div class="logo">
							<div class="logo-image" style="background-image: url('<?php echo e(logo_url('logo')); ?>');"></div>
						</div>
						<div class="details ml-4">
							<p class="text-dark mb-1 "><?php echo e(get_option('brand_name')); ?></p>
							<p class="mb-0 text-secondary"><?php echo e(get_option('address')); ?></p>
							<p class="mb-0 text-secondary"><?php echo e(get_option('country')); ?></p>
						</div>
					</div>
					<div class="inv-details">
						<p class="text-dark mb-1"><?php echo e(__('invoice.invoice_no')); ?></p>
						<p class="mb-0 text-secondary float-right"><?php echo e(format_invoice_no($invoice->id)); ?></p>
					</div>
				</div>
			</div>
			<div class="row biller-info">
				<div class="col-4">
					<p class="text-dark mb-1"><?php echo e(__('invoice.bill_to')); ?></p>
					<p class="mb-0 text-secondary"><?php echo e($invoice->member->name); ?></p>
					<p class="mb-0 text-secondary"><?php echo e($invoice->member->address); ?></p>
					<p class="mb-0 text-secondary"><?php echo e($invoice->member->phone); ?></p>
				</div>
				<div class="col-4">
					<p class="text-dark mb-1"><?php echo e(__('invoice.invoice_date')); ?></p>
					<p class="mb-0 text-secondary"><?php echo e(format_date($invoice->created_at)); ?></p>
				</div>
				<div class="col-4">
					<p class="text-dark mb-1"><?php echo e(__('invoice.amount_due')); ?></p>
					<p class="mb-0 text-secondary"><?php echo e(format_amount(due_amount($invoice->transactions))); ?></p>
				</div>
			</div>
			<div class="row">
				<div class="col-12">
					<table class="table table-striped custom-table-bordered ">
						<thead>
							<tr>
								<th><?php echo e(__('invoice.th_membership_type')); ?></th>
								<th><?php echo e(__('invoice.th_duration')); ?></th>
								<th><?php echo e(__('invoice.th_membership_fee')); ?></th>
								<th><?php echo e(__('invoice.th_total')); ?></th>
							</tr>
						</thead>
						<tbody>
							<tr class="text-secondary">
								<td><?php echo e($invoice->membership_type->name); ?></td>
								<td><?php echo e(pluralize($invoice->membership_type->duration)); ?></td>
								<td><?php echo e(format_amount($invoice->membership_type->amount)); ?></td>
								<td><?php echo e(format_amount($invoice->membership_type->amount)); ?></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
			<div class="row mt-5">
				<div class="offset-8 col-4 ">
					<div class="d-flex justify-content-between pb-3 border-bottom">
						<span class=""><?php echo e(__('invoice.subtotal')); ?></span>
						<span class="text-secondary"><?php echo e(format_amount($invoice->membership_type->amount)); ?></span>
					</div>
				</div>
				<div class="offset-8 col-4 mt-3 mb-2">
					<div class="d-flex justify-content-between">
						<span class=""><?php echo e(__('invoice.total')); ?></span>
						<span class="text-secondary"><?php echo e(format_amount($invoice->membership_type->amount)); ?></span>
					</div>
				</div>
				<div class="offset-8 col-4 mb-3">
					<div class="d-flex justify-content-between">
						<span class=""><?php echo e(__('invoice.amount_paid')); ?></span>
						<span class="text-secondary"><?php echo e(format_amount(paid_amount($invoice->transactions))); ?></span>
					</div>
				</div>
				<div class="offset-8 col-4 ">
					<div class="d-flex justify-content-between border-top pt-3">
						<span class=""><?php echo e(__('invoice.amount_payable', ['currency' => get_option('currency', 'USD')])); ?></span>
						<span class="text-secondary"><?php echo e(format_amount(due_amount($invoice->transactions))); ?></span>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js-script'); ?>
<script>
	window.addEventListener("load", window.print());
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.invoice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/invoice/print.blade.php ENDPATH**/ ?>